<?php 
include 'header.php';

$msg = "";
$err = "";
$catName = "";
$catId = "";

// Handle form submission
if(isset($_POST['category_submit'])){

    $catName = $link->real_escape_string($_POST['cat_name']);

    if(isset($_POST['cat_id']) && $_POST['cat_id'] != ''){
        $catId = $link->real_escape_string($_POST['cat_id']);
        $sqlUpdate = "UPDATE plan_categories SET name='$catName' WHERE id='$catId'";

        if(mysqli_query($link, $sqlUpdate)){
            $msg = "Plan Category updated successfully!";
        } else {
            $err = mysqli_error($link);
        }
    } else {
        $sqlInsert = "INSERT INTO plan_categories (name) VALUES ('$catName')";

        if(mysqli_query($link, $sqlInsert)){
            $msg = "Plan Category added successfully!";
        } else {
            $err = "Failed to add Plan Category!";
        }
    }
}

// Handle delete
if(isset($_GET['delete']) && $_GET['delete'] != ''){
    $deleteId = $link->real_escape_string($_GET['delete']);
    $sqlDelete = "DELETE FROM plan_categories WHERE id='$deleteId'";
    if(mysqli_query($link, $sqlDelete)){
        $msg = "Plan Category deleted successfully!";
    } else {
        $err = "Failed to delete category!";
    }
}

// Load category for edit
if(isset($_GET['id']) && $_GET['id'] != ''){
    $catId = $link->real_escape_string($_GET['id']);
    $sqlGet = "SELECT * FROM plan_categories WHERE id='$catId'";
    $result = mysqli_query($link, $sqlGet);
    if(mysqli_num_rows($result) > 0){
        $row = mysqli_fetch_assoc($result);
        $catName = $row['name'];
    }
}
?>

<div class="page-content">
    <div class="container-fluid">
        <?php 
        if($msg != "") echo customAlert("success", $msg);
        if($err != "") echo customAlert("error", $err);
        ?>

        <h4 align="center"><i class="fa fa-folder"></i> PLAN CATEGORIES MANAGEMENT</h4>
        <br>

        <!-- Category Form -->
        <form class="form-horizontal" action="" method="POST">
            <legend>Plan Category</legend>

            <div class="form-group">
                <label>Category Name</label>
                <input type="text" name="cat_name" placeholder="Category Name" value="<?php echo $catName; ?>" class="form-control" required>
            </div>

            <br>
            <?php if($catId == "") { ?>
                <button type="submit" class="btn btn-info" name="category_submit">Add Category</button>
            <?php } else { ?>
                <input type="hidden" name="cat_id" value="<?php echo $catId; ?>">
                <button type="submit" class="btn btn-info" name="category_submit">Update Category</button>
                <a href="plan-categories.php" class="btn btn-secondary">Cancel</a>
            <?php } ?>
        </form>

        <hr>

        <!-- Existing Categories Table -->
        <h5>Existing Categories</h5>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Category Name</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sqlAll = "SELECT * FROM plan_categories ORDER BY id DESC";
                $resultAll = mysqli_query($link, $sqlAll);
                if(mysqli_num_rows($resultAll) > 0){
                    $count = 1;
                    while($rowAll = mysqli_fetch_assoc($resultAll)){
                        echo "<tr>
                                <td>".$count++."</td>
                                <td>".htmlspecialchars($rowAll['name'])."</td>
                                <td>
                                   
                                    <a href='plan-categories.php?delete=".$rowAll['id']."' class='btn btn-sm btn-danger' onclick=\"return confirm('Are you sure you want to delete this category?')\">Delete</a>
                                </td>
                              </tr>";
                    }
                } else {
                    echo "<tr><td colspan='3' align='center'>No categories found.</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<?php 
include 'footer.php';
?>
