<?php
include 'header.php';

$msg = "";
$err = "";
$planName = "";
$categoryId = "";
$minAmount = "";
$maxAmount = "";
$roi = "";
$refBonusPercent = "";
$planId = "";

// Handle form submission
if(isset($_POST['plan_submit'])){
    $planName = $link->real_escape_string($_POST['plan_name']);
    $categoryId = $link->real_escape_string($_POST['category_id']);
    $minAmount = $link->real_escape_string($_POST['min_amount']);
    $maxAmount = $link->real_escape_string($_POST['max_amount']);
    $roi = $link->real_escape_string($_POST['roi']);
    $refBonusPercent = $link->real_escape_string($_POST['ref_bonus_percent']);

    if(isset($_POST['plan_id']) && $_POST['plan_id'] != ''){
        $planId = $link->real_escape_string($_POST['plan_id']);
        $sqlUpdate = "UPDATE investment_plans 
                      SET name='$planName', category_id='$categoryId', min_amount='$minAmount', 
                          max_amount='$maxAmount', roi='$roi', ref_bonus_percent='$refBonusPercent' 
                      WHERE id='$planId'";
        if(mysqli_query($link, $sqlUpdate)){
            $msg = "Investment Plan updated successfully!";
        } else {
            $err = mysqli_error($link);
        }
    } else {
        $sqlInsert = "INSERT INTO investment_plans (name, category_id, min_amount, max_amount, roi, ref_bonus_percent) 
                      VALUES ('$planName','$categoryId','$minAmount','$maxAmount','$roi','$refBonusPercent')";
        if(mysqli_query($link, $sqlInsert)){
            $msg = "Investment Plan added successfully!";
        } else {
            $err = "Failed to add Investment Plan!";
        }
    }
}

// Load plan for edit
if(isset($_GET['id']) && $_GET['id'] != ''){
    $planId = $link->real_escape_string($_GET['id']);
    $sqlGet = "SELECT * FROM investment_plans WHERE id='$planId'";
    $result = mysqli_query($link, $sqlGet);
    if(mysqli_num_rows($result) > 0){
        $row = mysqli_fetch_assoc($result);
        $planName = $row['name'];
        $categoryId = $row['category_id'];
        $minAmount = $row['min_amount'];
        $maxAmount = $row['max_amount'];
        $roi = $row['roi'];
        $refBonusPercent = $row['ref_bonus_percent'];
    }
}

// Handle delete
if (isset($_GET['delete']) && $_GET['delete'] != '') {
    $deleteId = $link->real_escape_string($_GET['delete']);
    $sqlDelete = "DELETE FROM investment_plans WHERE id='$deleteId'";
    if (mysqli_query($link, $sqlDelete)) {
        $msg = "Investment Plan deleted successfully!";
    } else {
        $err = "Failed to delete plan: " . mysqli_error($link);
    }
}


// Load all categories for dropdown
$categories = [];
$sqlCat = "SELECT * FROM plan_categories ORDER BY name ASC";
$resCat = mysqli_query($link, $sqlCat);
if(mysqli_num_rows($resCat) > 0){
    while($rowCat = mysqli_fetch_assoc($resCat)){
        $categories[] = $rowCat;
    }
}
?>

<div class="page-content">
    <div class="container-fluid">
        <?php 
        if($msg != "") echo customAlert("success", $msg);
        if($err != "") echo customAlert("error", $err);
        ?>

        <h4 align="center"><i class="fa fa-money-bill"></i> INVESTMENT PLANS MANAGEMENT</h4>
        <br>

        <form class="form-horizontal" action="investment-plans.php" method="POST">
            <legend>Investment Plan</legend>

            <div class="form-group">
                <label>Plan Name</label>
                <input type="text" name="plan_name" placeholder="Plan Name" value="<?php echo $planName; ?>" class="form-control" required>
            </div>

            <div class="form-group">
                <label>Category</label>
                <select name="category_id" class="form-control" required>
                    <option value="">Select Category</option>
                    <?php foreach($categories as $cat){ ?>
                        <option value="<?php echo $cat['id']; ?>" <?php if($categoryId == $cat['id']) echo "selected"; ?>>
                            <?php echo htmlspecialchars($cat['name']); ?>
                        </option>
                    <?php } ?>
                </select>
            </div>

            <div class="form-group">
                <label>Minimum Amount</label>
                <input type="number" step="0.01" name="min_amount" placeholder="Minimum Amount" value="<?php echo $minAmount; ?>" class="form-control" required>
            </div>

            <div class="form-group">
                <label>Maximum Amount</label>
                <input type="number" step="0.01" name="max_amount" placeholder="Maximum Amount" value="<?php echo $maxAmount; ?>" class="form-control" required>
            </div>

            <div class="form-group">
                <label>ROI (%)</label>
                <input type="number" step="0.01" name="roi" placeholder="ROI Percentage" value="<?php echo $roi; ?>" class="form-control" required>
            </div>

            <div class="form-group">
                <label>Referral Bonus (%)</label>
                <input type="number" step="0.01" name="ref_bonus_percent" placeholder="Referral Bonus Percentage" value="<?php echo $refBonusPercent; ?>" class="form-control" required>
            </div>

            <br>
            <?php if($planId == "") { ?>
                <button type="submit" class="btn btn-info" name="plan_submit">Add Plan</button>
            <?php } else { ?>
                <input type="hidden" name="plan_id" value="<?php echo $planId; ?>">
                <button type="submit" class="btn btn-info" name="plan_submit">Update Plan</button>
                <a href="investment-plans.php" class="btn btn-secondary">Cancel</a>
            <?php } ?>
        </form>

        <hr>

        <!-- Existing Investment Plans Table -->
        <h5>Existing Investment Plans</h5>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Plan Name</th>
                    <th>Category</th>
                    <th>Min Amount</th>
                    <th>Max Amount</th>
                    <th>ROI (%)</th>
                    <th>Referral Bonus (%)</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sqlPlans = "SELECT ip.*, pc.name AS category_name 
                             FROM investment_plans ip 
                             JOIN plan_categories pc ON ip.category_id = pc.id 
                             ORDER BY ip.id DESC";
                $resPlans = mysqli_query($link, $sqlPlans);
                if(mysqli_num_rows($resPlans) > 0){
                    $count = 1;
                    while($rowPlan = mysqli_fetch_assoc($resPlans)){
                        echo "<tr>
                                <td>".$count++."</td>
                                <td>".htmlspecialchars($rowPlan['name'])."</td>
                                <td>".htmlspecialchars($rowPlan['category_name'])."</td>
                                <td>".$rowPlan['min_amount']."</td>
                                <td>".$rowPlan['max_amount']."</td>
                                <td>".$rowPlan['roi']."</td>
                                <td>".$rowPlan['ref_bonus_percent']."</td>
                                <td>
                                    <a href='investment-plans.php?id=".$rowPlan['id']."' class='btn btn-sm btn-primary'>Edit</a>
                                    <a href='investment-plans.php?delete=".$rowPlan['id']."' class='btn btn-sm btn-danger' onclick=\"return confirm('Are you sure you want to delete this plan?')\">Delete</a>
                                </td>
                              </tr>";
                    }
                } else {
                    echo "<tr><td colspan='8' align='center'>No investment plans found.</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<?php
include 'footer.php';
?>
