<?php
include 'header.php';
$msg = "";
$err = "";

// --- Handle Add Plan (Normal Submit) ---
if (isset($_POST['add_plan'])) {
    $plan_name = trim($_POST['plan_name']);
    $plan_min_invest = trim($_POST['plan_min_invest']);
    $plan_max_invest = trim($_POST['plan_max_invest']);
    $plan_daily_profit = trim($_POST['plan_daily_profit']);
    $plan_duration = trim($_POST['plan_duration']);
    $plan_description = trim($_POST['plan_description']);

    if ($plan_name == '' || $plan_min_invest == '' || $plan_max_invest == '' || $plan_daily_profit == '' || $plan_duration == '') {
        $err = "All fields marked * are required.";
    } else {
        $query = "INSERT INTO ai_trading_plans (plan_name, min_invest, max_invest, daily_profit, duration, description, created_at)
                  VALUES ('$plan_name', '$plan_min_invest', '$plan_max_invest', '$plan_daily_profit', '$plan_duration', '$plan_description', NOW())";
        $insert = mysqli_query($link, $query);

        if ($insert) {
            $msg = "✅ Plan added successfully.";
        } else {
            $err = "Error: " . mysqli_error($link);
        }
    }
}

// --- Handle Delete Plan ---
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($link, "DELETE FROM ai_trading_plans WHERE id='$id'");
    $msg = "Plan deleted successfully.";
}

// Fetch all plans
$plans = mysqli_query($link, "SELECT * FROM ai_trading_plans ORDER BY id DESC");
?>

<div class="page-content">
    <div class="container-fluid">

        <!-- ADD PLAN FORM -->
        <div class="row justify-content-center mb-5">
            <div class="col-xxl-8 col-lg-10">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white rounded-top">
                        <h4 class="mb-0"><i class="fas fa-robot me-2"></i>Add AI Trading Plan</h4>
                    </div>
                    <div class="card-body p-4">
                        <?php if ($msg): ?>
                            <div class="alert alert-success"><?php echo $msg; ?></div>
                        <?php elseif ($err): ?>
                            <div class="alert alert-danger"><?php echo $err; ?></div>
                        <?php endif; ?>

                        <form method="POST">
                            <div class="row g-4">
                                <div class="col-md-6">
                                    <label class="form-label">Plan Name *</label>
                                    <input type="text" name="plan_name" class="form-control" required>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Min Investment ($)*</label>
                                    <input type="number" name="plan_min_invest" class="form-control" required>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Max Investment ($)*</label>
                                    <input type="number" name="plan_max_invest" class="form-control" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Daily Profit %*</label>
                                    <input type="number" step="0.01" name="plan_daily_profit" class="form-control" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Duration (Days)*</label>
                                    <input type="number" name="plan_duration" class="form-control" required>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Description</label>
                                    <textarea name="plan_description" class="form-control" rows="3"></textarea>
                                </div>
                                <div class="col-12 text-end">
                                    <button type="submit" name="add_plan" class="btn btn-primary px-4">
                                        <i class="fas fa-plus-circle me-1"></i> Add Plan
                                    </button>
                                    <button type="reset" class="btn btn-soft-danger">Reset</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- PLANS TABLE -->
        <div class="row justify-content-center">
            <div class="col-xxl-10 col-lg-12">
                <div class="card shadow-sm">
                    <div class="card-header bg-dark text-white">
                        <h5 class="mb-0">All AI Trading Plans</h5>
                    </div>
                    <div class="card-body">
                        <?php if (mysqli_num_rows($plans) > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead class="table-dark">
                                        <tr>
                                            <th>ID</th>
                                            <th>Plan Name</th>
                                            <th>Daily Profit %</th>
                                            <th>Min Invest ($)</th>
                                            <th>Max Invest ($)</th>
                                            <th>Duration (Days)</th>
                                            <th>Description</th>
                                            <th>Created At</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while ($row = mysqli_fetch_assoc($plans)): ?>
                                            <tr>
                                                <td><?php echo $row['id']; ?></td>
                                                <td><?php echo $row['plan_name']; ?></td>
                                                <td><?php echo $row['daily_profit']; ?>%</td>
                                                <td>$<?php echo $row['min_invest']; ?></td>
                                                <td>$<?php echo $row['max_invest']; ?></td>
                                                <td><?php echo $row['duration']; ?></td>
                                                <td><?php echo $row['description']; ?></td>
                                                <td><?php echo $row['created_at']; ?></td>
                                                <td>
                                                    <a href="?delete=<?php echo $row['id']; ?>" 
                                                       class="btn btn-sm btn-danger" 
                                                       onclick="return confirm('Delete this plan?')">
                                                       Delete
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-center text-muted">No AI trading plans found.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php include 'footer.php'; ?>
