<?php
session_start();
include "header.php";

if (!isset($_SESSION['USERLOGIN'])) {
    header("Location: login.php");
    exit();
}

$msg = "";
$err = "";

// Handle trade submission
if (isset($_POST['type'])) {
    $asset   = mysqli_real_escape_string($link, $_POST['asset']);
    $amount  = floatval($_POST['amount']);
    $type    = mysqli_real_escape_string($link, $_POST['type']);
    $status  = 'open';
    $created = date('Y-m-d H:i:s');

    if ($amount > 0 && !empty($asset)) {
        $sql = "INSERT INTO trades (user_id, asset, amount, status, profit_loss, created_at)
                VALUES ('$uid', '$asset', '$amount', '$status', '0', '$created')";
        if (mysqli_query($link, $sql)) {
            $msg = strtoupper($type) . " trade placed successfully!";
        } else {
            $err = "Error: " . mysqli_error($link);
        }
    } else {
        $err = "Please select an asset and enter a valid amount.";
    }
}
?>

<style>
label {
    color: white !important;
}
.buy-btn {
    background: #28a745;
    color: #fff;
    border: none;
    padding: 10px 25px;
    border-radius: 8px;
    font-weight: bold;
}
.sell-btn {
    background: #dc3545;
    color: #fff;
    border: none;
    padding: 10px 25px;
    border-radius: 8px;
    font-weight: bold;
}
.trade-buttons button:hover {
    opacity: 0.9;
}
.table th, .table td {
    color: white;
}
</style>

<div class="page-content">
    <div class="container-fluid">
        <?php 
        if ($msg != "") echo customAlert("success", $msg);
        if ($err != "") echo customAlert("error", $err);
        ?>

        <div class="row">
            <div class="col-lg-8 offset-lg-2">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0" style="color: white;">Trade</h4>
                    </div>

                    <div>
                        <iframe id="tradingview_01a5c"
                            src="https://s.tradingview.com/widgetembed/?frameElementId=tradingview_01a5c&amp;symbol=COINBASE%3ABTCUSD&amp;interval=1&amp;theme=dark&amp;style=9&amp;timezone=Etc%2FUTC"
                            style="width: 100%; height: 450px; margin: 0; padding: 0;" frameborder="0" allowtransparency="true" scrolling="no" allowfullscreen></iframe>
                    </div>

                    <div class="card-body">
                        <form method="post" action="">
                            <div class="mb-3">
                                <label class="form-label">Select Category</label>
                                <select id="categorySelect" class="form-control" style="color:black;">
                                    <option value="">--Select Category--</option>
                                    <option value="crypto">Crypto</option>
                                    <option value="forex">Forex</option>
                                    <option value="stock">Stocks</option>
                                    <option value="index">Indices</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Select Asset</label>
                                <select class="form-control" name="asset" required style="color:black;">
                                    <option value="">--Select Asset--</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Amount ($)</label>
                                <input type="number" step="0.01" min="1" class="form-control" name="amount" required>
                            </div>

                            <div class="trade-buttons d-flex justify-content-between">
                                <button type="submit" name="type" value="buy" class="buy-btn w-50 me-2">BUY</button>
                                <button type="submit" name="type" value="sell" class="sell-btn w-50">SELL</button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Active Trades -->
                <div class="card mt-5">
                    <div class="card-header">
                        <h4 class="card-title mb-0" style="color: white;">My Active Trades</h4>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Asset</th>
                                    <th>Amount ($)</th>
                                    <th>Status</th>
                                    <th>Profit/Loss ($)</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $res = mysqli_query($link, "SELECT * FROM trades WHERE user_id='$uid' ORDER BY id DESC");
                                if (mysqli_num_rows($res) > 0) {
                                    while ($row = mysqli_fetch_assoc($res)) {
                                        echo "<tr>
                                            <td>{$row['id']}</td>
                                            <td>{$row['asset']}</td>
                                            <td>\${$row['amount']}</td>
                                            <td>{$row['status']}</td>
                                            <td>\${$row['profit_loss']}</td>
                                            <td>{$row['created_at']}</td>
                                        </tr>";
                                    }
                                } else {
                                    echo "<tr><td colspan='6' class='text-center'>No trades yet</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- ✅ Dynamic Asset Script -->
<script>
document.addEventListener("DOMContentLoaded", function () {
    const categorySelect = document.getElementById("categorySelect");
    const assetSelect = document.querySelector("select[name='asset']");

    const assetsByCategory = {
        crypto: [
            { value: "BTC", text: "Bitcoin (BTC)" },
            { value: "ETH", text: "Ethereum (ETH)" },
            { value: "BNB", text: "Binance Coin (BNB)" },
            { value: "SOL", text: "Solana (SOL)" },
            { value: "XRP", text: "Ripple (XRP)" }
        ],
        forex: [
            { value: "EURUSD", text: "EUR/USD" },
            { value: "GBPUSD", text: "GBP/USD" },
            { value: "USDJPY", text: "USD/JPY" },
            { value: "USDCAD", text: "USD/CAD" },
            { value: "AUDUSD", text: "AUD/USD" }
        ],
        stock: [
            { value: "AAPL", text: "Apple (AAPL)" },
            { value: "TSLA", text: "Tesla (TSLA)" },
            { value: "AMZN", text: "Amazon (AMZN)" },
            { value: "MSFT", text: "Microsoft (MSFT)" },
            { value: "GOOGL", text: "Alphabet (GOOGL)" }
        ],
        index: [
            { value: "SPX500", text: "S&P 500 (SPX500)" },
            { value: "NAS100", text: "Nasdaq 100 (NAS100)" },
            { value: "DJ30", text: "Dow Jones (DJ30)" },
            { value: "GER30", text: "DAX 30 (GER30)" },
            { value: "UK100", text: "FTSE 100 (UK100)" }
        ]
    };

    categorySelect.addEventListener("change", function () {
        const selectedCategory = this.value;
        assetSelect.innerHTML = '<option value="">--Select Asset--</option>';

        if (assetsByCategory[selectedCategory]) {
            assetsByCategory[selectedCategory].forEach(asset => {
                const option = document.createElement("option");
                option.value = asset.value;
                option.textContent = asset.text;
                assetSelect.appendChild(option);
            });
        }
    });
});
</script>

<?php include "footer.php"; ?>
