<?php
include 'header.php';

$msg = "";
$err = "";

// Handle new expert addition
if (isset($_POST['add_expert'])) {
    $expert_name = trim($_POST['expert_name']);
    $expert_email = trim($_POST['expert_email']);
    $expert_country = trim($_POST['expert_country']);
    $expert_profit = trim($_POST['expert_profit']);
    $expert_min_deposit = trim($_POST['expert_min_deposit']);
    $expert_description = trim($_POST['expert_description']);

    if (empty($expert_name) || empty($expert_email) || empty($expert_country) || empty($expert_profit) || empty($expert_min_deposit)) {
        $err = "All fields marked * are required.";
    } elseif (!filter_var($expert_email, FILTER_VALIDATE_EMAIL)) {
        $err = "Invalid email address.";
    } else {
        $query = "INSERT INTO copytrade_experts (name, email, country, profit_percent, min_deposit, description, created_at)
                  VALUES ('$expert_name', '$expert_email', '$expert_country', '$expert_profit', '$expert_min_deposit', '$expert_description', NOW())";
        $insert = mysqli_query($link, $query);

        if ($insert) {
            $msg = "Copytrade Expert added successfully!";
        } else {
            $err = "Error adding expert: " . mysqli_error($link);
        }
    }
}
?>

<div class="page-content">
    <div class="container-fluid">
        <?php 
        if ($msg != "") echo customAlert("success", $msg);
        if ($err != "") echo customAlert("error", $err);
        ?>

        <!-- ADD FORM -->
        <div class="row justify-content-center mb-5">
            <div class="col-xxl-8 col-lg-10">
                <div class="card mt-xxl-n5 shadow-sm">
                    <div class="card-header bg-primary text-white rounded-top">
                        <h4 class="mb-0" style="color: white;">
                            <i class="fas fa-user-tie me-2"></i>Add Copytrade Expert
                        </h4>
                    </div>
                    <div class="card-body p-4">
                        <form action="copy-trades.php" method="post" id="addExpertForm">
                            <div class="row g-4">
                                <div class="col-md-6">
                                    <label class="form-label">Expert Name <span class="text-danger">*</span></label>
                                    <input type="text" name="expert_name" class="form-control" placeholder="Enter expert name" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Email <span class="text-danger">*</span></label>
                                    <input type="email" name="expert_email" class="form-control" placeholder="Enter expert email" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Country <span class="text-danger">*</span></label>
                                    <input type="text" name="expert_country" class="form-control" placeholder="Enter country" required>
                                </div>

                                <div class="col-md-3">
                                    <label class="form-label">Profit % <span class="text-danger">*</span></label>
                                    <input type="number" step="0.01" name="expert_profit" class="form-control" placeholder="e.g. 25" required>
                                </div>

                                <div class="col-md-3">
                                    <label class="form-label">Min Deposit ($) <span class="text-danger">*</span></label>
                                    <input type="number" name="expert_min_deposit" class="form-control" placeholder="e.g. 100" required>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Expert Description</label>
                                    <textarea name="expert_description" class="form-control" rows="4" placeholder="Brief profile or trading strategy..."></textarea>
                                </div>

                                <div class="col-12 text-end">
                                    <button type="submit" name="add_expert" class="btn btn-primary px-4">
                                        <i class="fas fa-plus-circle me-1"></i> Add Expert
                                    </button>
                                    <button type="reset" class="btn btn-soft-danger">Reset</button>
                                </div>
                            </div><!-- end row -->
                        </form>
                    </div>
                </div>
            </div><!-- end col -->
        </div><!-- end row -->

        <!-- EXPERT LIST -->
        <div class="row justify-content-center">
            <div class="col-xxl-10 col-lg-12">
                <div class="card shadow-sm">
                    <div class="card-header bg-dark text-white">
                        <h5 class="mb-0">All Copytrade Experts</h5>
                    </div>
                    <div class="card-body">
                        <div id="expertsTable">
                            <!-- Data loads here via AJAX -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- EDIT MODAL -->
        <div class="modal fade" id="editExpertModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <form id="editExpertForm">
                        <div class="modal-header bg-primary text-white">
                            <h5 class="modal-title">Edit Copytrade Expert</h5>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" name="id" id="edit_id">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Name</label>
                                    <input type="text" id="edit_name" name="name" class="form-control" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Email</label>
                                    <input type="email" id="edit_email" name="email" class="form-control" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Country</label>
                                    <input type="text" id="edit_country" name="country" class="form-control" required>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Profit %</label>
                                    <input type="number" id="edit_profit" step="0.01" name="profit_percent" class="form-control" required>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Min Deposit</label>
                                    <input type="number" id="edit_min_deposit" name="min_deposit" class="form-control" required>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Description</label>
                                    <textarea id="edit_description" name="description" class="form-control" rows="3"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Save Changes</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div><!-- container-fluid -->
</div><!-- End Page-content -->

<!-- AJAX LOGIC -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    loadExperts();

    function loadExperts() {
        $.ajax({
            url: "copytrade_actions.php",
            type: "POST",
            data: { action: "fetch" },
            success: function(response) {
                $("#expertsTable").html(response);
            }
        });
    }

    // Edit button click
    $(document).on("click", ".edit-btn", function() {
        let id = $(this).data("id");
        $.ajax({
            url: "copytrade_actions.php",
            type: "POST",
            data: { action: "get", id: id },
            dataType: "json",
            success: function(data) {
                $("#edit_id").val(data.id);
                $("#edit_name").val(data.name);
                $("#edit_email").val(data.email);
                $("#edit_country").val(data.country);
                $("#edit_profit").val(data.profit_percent);
                $("#edit_min_deposit").val(data.min_deposit);
                $("#edit_description").val(data.description);
                $("#editExpertModal").modal("show");
            }
        });
    });

    // Update expert
    $("#editExpertForm").submit(function(e) {
        e.preventDefault();
        $.ajax({
            url: "copytrade_actions.php",
            type: "POST",
            data: $(this).serialize() + "&action=update",
            success: function(response) {
                $("#editExpertModal").modal("hide");
                loadExperts();
            }
        });
    });

    // Delete expert
    $(document).on("click", ".delete-btn", function() {
        if (confirm("Are you sure you want to delete this expert?")) {
            let id = $(this).data("id");
            $.ajax({
                url: "copytrade_actions.php",
                type: "POST",
                data: { action: "delete", id: id },
                success: function() {
                    loadExperts();
                }
            });
        }
    });
});
</script>

<?php include 'footer.php'; ?>
