<?php
session_start();

require_once '../config/db.php';
include '../config/config.php';
include '../config/functions.php';

$action = $_POST['action'] ?? '';

if ($action == 'fetch') {
    $query = "SELECT * FROM ai_trading_plans ORDER BY id DESC";
    $result = mysqli_query($link, $query);

    if (mysqli_num_rows($result) > 0) {
        echo '<div class="table-responsive">';
        echo '<table class="table table-bordered table-striped">';
        echo '<thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>Plan Name</th>
                    <th>Daily Profit %</th>
                    <th>Min Investment ($)</th>
                    <th>Max Investment ($)</th>
                    <th>Duration (Days)</th>
                    <th>Description</th>
                    <th>Created At</th>
                    <th>Actions</th>
                </tr>
              </thead><tbody>';
        while ($row = mysqli_fetch_assoc($result)) {
            echo '<tr>
                    <td>'.$row['id'].'</td>
                    <td>'.$row['plan_name'].'</td>
                    <td>'.$row['daily_profit'].'%</td>
                    <td>$'.$row['min_invest'].'</td>
                    <td>$'.$row['max_invest'].'</td>
                    <td>'.$row['duration'].'</td>
                    <td>'.$row['description'].'</td>
                    <td>'.$row['created_at'].'</td>
                    <td>
                        <button class="btn btn-sm btn-primary edit-btn" data-id="'.$row['id'].'">Edit</button>
                        <button class="btn btn-sm btn-danger delete-btn" data-id="'.$row['id'].'">Delete</button>
                    </td>
                  </tr>';
        }
        echo '</tbody></table></div>';
    } else {
        echo "<p class='text-center text-muted'>No AI trading plans found.</p>";
    }
}

elseif ($action == 'get' && isset($_POST['id'])) {
    $id = intval($_POST['id']);
    $query = "SELECT * FROM ai_trading_plans WHERE id='$id' LIMIT 1";
    $result = mysqli_query($link, $query);
    echo json_encode(mysqli_fetch_assoc($result));
}

elseif ($action == 'update') {
    $id = intval($_POST['id']);
    $name = mysqli_real_escape_string($link, $_POST['name']);
    $min = floatval($_POST['min_invest']);
    $max = floatval($_POST['max_invest']);
    $profit = floatval($_POST['daily_profit']);
    $duration = intval($_POST['duration']);
    $desc = mysqli_real_escape_string($link, $_POST['description']);

    $query = "UPDATE ai_trading_plans SET 
                plan_name='$name',
                min_invest='$min',
                max_invest='$max',
                daily_profit='$profit',
                duration='$duration',
                description='$desc'
              WHERE id='$id'";
    mysqli_query($link, $query);
    echo "success";
}

elseif ($action == 'delete' && isset($_POST['id'])) {
    $id = intval($_POST['id']);
    $query = "DELETE FROM ai_trading_plans WHERE id='$id'";
    mysqli_query($link, $query);
    echo "deleted";
}

else {
    echo "Invalid action.";
}
?>
